/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.api.guide.lines;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.JsonHelper;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.notification.ClickAction;
import ftb.utils.api.guide.GuidePage;
import ftb.utils.api.guide.lines.GuideTextLine;
import ftb.utils.mod.client.gui.guide.ButtonGuideExtendedTextLine;
import ftb.utils.mod.client.gui.guide.ButtonGuideTextLine;
import ftb.utils.mod.client.gui.guide.GuiGuide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.IChatComponent;

public class GuideExtendedTextLine
extends GuideTextLine {
    protected IChatComponent text;
    private ClickAction clickAction;
    private List<IChatComponent> hover;

    public GuideExtendedTextLine(GuidePage c, IChatComponent cc) {
        super(c, null);
        this.text = cc;
        if (this.text != null) {
            HoverEvent hoverEvent;
            ClickEvent clickEvent = this.text.func_150256_b().func_150235_h();
            if (clickEvent != null) {
                this.clickAction = ClickAction.from((ClickEvent)clickEvent);
            }
            if ((hoverEvent = this.text.func_150256_b().func_150210_i()) != null && hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
                this.hover = Collections.singletonList(hoverEvent.func_150702_b());
            }
        }
    }

    @Override
    public IChatComponent getText() {
        return this.text;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ButtonGuideTextLine createWidget(GuiGuide gui) {
        return new ButtonGuideExtendedTextLine(gui, this);
    }

    public List<IChatComponent> getHover() {
        return this.hover;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasClickAction() {
        return this.clickAction != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void onClicked() {
        if (this.clickAction != null) {
            FTBLibClient.playClickSound();
            this.clickAction.onClicked();
        }
    }

    @Override
    public void func_152753_a(JsonElement e) {
        JsonObject o = e.getAsJsonObject();
        IChatComponent iChatComponent = this.text = o.has("text") ? JsonHelper.deserializeICC((JsonElement)o.get("text")) : null;
        if (o.has("click")) {
            this.clickAction = new ClickAction();
            this.clickAction.func_152753_a(o.get("click"));
        } else {
            this.clickAction = null;
        }
        if (o.has("hover")) {
            this.hover = new ArrayList<IChatComponent>();
            JsonElement e1 = o.get("hover");
            if (e1.isJsonPrimitive()) {
                this.hover.add(JsonHelper.deserializeICC((JsonElement)e1));
            } else {
                for (JsonElement e2 : o.get("hover").getAsJsonArray()) {
                    this.hover.add(JsonHelper.deserializeICC((JsonElement)e2));
                }
            }
            if (this.hover.isEmpty()) {
                this.hover = null;
            }
        } else {
            this.hover = null;
        }
    }

    @Override
    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        if (this.text != null) {
            o.add("text", JsonHelper.serializeICC((IChatComponent)this.text));
        }
        if (this.clickAction != null) {
            o.add("click", this.clickAction.func_151003_a());
        }
        if (this.hover != null && !this.hover.isEmpty()) {
            if (this.hover.size() == 1) {
                o.add("hover", JsonHelper.serializeICC((IChatComponent)this.hover.get(0)));
            } else {
                JsonArray a = new JsonArray();
                for (IChatComponent c : this.hover) {
                    a.add(JsonHelper.serializeICC((IChatComponent)c));
                }
                o.add("hover", (JsonElement)a);
            }
        }
        return o;
    }

    public void setClickAction(ClickAction a) {
        this.clickAction = a;
    }

    public void setHover(List<IChatComponent> h) {
        if (h == null || h.isEmpty()) {
            this.hover = null;
        } else {
            this.hover = new ArrayList<IChatComponent>(h.size());
            this.hover.addAll(h);
        }
    }
}

