/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.net;

import ftb.utils.api.guide.ServerGuideFile;
import ftb.utils.net.MessageClientAction;
import ftb.utils.net.MessageLMPlayerInfo;
import ftb.utils.net.MessageLMPlayerUpdate;
import ftb.utils.world.LMPlayerServer;
import java.util.HashMap;

public abstract class ClientAction {
    public static final ClientAction NULL = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            return false;
        }
    };
    public static final ClientAction ADD_FRIEND = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            if (extra > 0) {
                LMPlayerServer p = owner.world.getPlayer(extra);
                if (p == null || p.equalsPlayer(owner)) {
                    return false;
                }
                if (!owner.friends.contains(p.getPlayerID())) {
                    owner.friends.add(p.getPlayerID());
                    owner.sendUpdate();
                    p.sendUpdate();
                    p.checkNewFriends();
                }
            } else {
                for (LMPlayerServer p : owner.world.playerMap.values()) {
                    if (p.equalsPlayer(owner) || !p.isFriendRaw(owner) || owner.isFriendRaw(p)) continue;
                    owner.friends.add(p.getPlayerID());
                    owner.sendUpdate();
                    p.sendUpdate();
                    p.checkNewFriends();
                }
            }
            return true;
        }
    };
    public static final ClientAction REM_FRIEND = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            LMPlayerServer p = owner.world.getPlayer(extra);
            if (p == null || p.equalsPlayer(owner)) {
                return false;
            }
            if (owner.friends.contains(p.getPlayerID())) {
                owner.friends.removeValue(p.getPlayerID());
                owner.sendUpdate();
                p.sendUpdate();
                p.checkNewFriends();
            }
            return true;
        }
    };
    public static final ClientAction DENY_FRIEND = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            LMPlayerServer p = owner.world.getPlayer(extra);
            if (p == null || p.equalsPlayer(owner)) {
                return false;
            }
            if (p.friends.contains(owner.getPlayerID())) {
                p.friends.removeValue(owner.getPlayerID());
                owner.sendUpdate();
                p.sendUpdate();
            }
            return true;
        }
    };
    public static final ClientAction REQUEST_PLAYER_INFO = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            new MessageLMPlayerInfo(owner, extra).sendTo(owner.getPlayer());
            return false;
        }
    };
    public static final ClientAction REQUEST_SERVER_INFO = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            new ServerGuideFile(owner).displayGuide(owner.getPlayer());
            return false;
        }
    };
    public static final ClientAction REQUEST_SELF_UPDATE = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            new MessageLMPlayerUpdate(owner, true).sendTo(owner.getPlayer());
            return false;
        }
    };
    public static final ClientAction BUTTON_RENDER_BADGE = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            owner.renderBadge = extra == 1;
            return true;
        }
    };
    public static final ClientAction BUTTON_CHAT_LINKS = new ClientAction(){

        @Override
        public boolean onAction(int extra, LMPlayerServer owner) {
            owner.getSettings().set((byte)0, extra == 1);
            return true;
        }
    };
    private static final HashMap<Byte, ClientAction> map = new HashMap();
    private byte ID;

    private static void register(int i, ClientAction c) {
        c.ID = (byte)i;
        map.put(c.getID(), c);
    }

    private ClientAction() {
    }

    public byte getID() {
        return this.ID;
    }

    public abstract boolean onAction(int var1, LMPlayerServer var2);

    public void send(int extra) {
        new MessageClientAction(this, extra).sendToServer();
    }

    public static ClientAction get(byte id) {
        if (id == 0) {
            return NULL;
        }
        ClientAction a = map.get(id);
        if (a == null) {
            return NULL;
        }
        return a;
    }

    static {
        ClientAction.register(0, NULL);
        ClientAction.register(1, ADD_FRIEND);
        ClientAction.register(2, REM_FRIEND);
        ClientAction.register(3, DENY_FRIEND);
        ClientAction.register(4, REQUEST_PLAYER_INFO);
        ClientAction.register(5, REQUEST_SERVER_INFO);
        ClientAction.register(6, REQUEST_SELF_UPDATE);
        ClientAction.register(8, BUTTON_RENDER_BADGE);
        ClientAction.register(9, BUTTON_CHAT_LINKS);
    }
}

